// config: norepeat

#include "GetPoint.js"
#include "GetLine.js"

function AddImage()
{
	var factory = moi.command.createFactory( 'backgroundimage' );
	var filename = factory.getOpenFileName();
	
	if ( filename == '' )
		return false;
		
	factory.setInput( 0, filename );
	
	var ui = moi.ui;
	
	ui.beginUIUpdate();
	ui.hideUI( 'ImageOptions' );
	ui.hideUI( 'LastRectPrompt' );
	ui.hideUI( 'AlignPrompt1' );
	ui.hideUI( 'AlignPrompt2' );
	ui.hideUI( 'AlignPrompt3' );
	ui.hideUI( 'AlignPrompt4' );
	ui.hideUI( 'done' );
	ui.showUI( 'PromptContainer' );
	ui.showUI( 'FirstRectPrompt' );
	ui.endUIUpdate();
	
	var pointpicker = ui.createPointPicker();
	pointpicker.allowNestedCancel();
	factory.addSnaps( pointpicker );
	
	if ( !GetPoint( pointpicker ) )
	{
		factory.cancel();
		ui.redrawViewports();
		return false;
	}
		
	factory.setInput( 1, pointpicker.ptframe );
		
	ui.beginUIUpdate();
	ui.hideUI( 'FirstRectPrompt' );
	ui.showUI( 'LastRectPrompt' );
	ui.endUIUpdate();
	
	pointpicker.restrictToPlaneThroughPt( pointpicker.pt, false );
	pointpicker.disableVerticalStraightSnap = true;
	pointpicker.disableStraightSnapAngle( 0 );
	pointpicker.disableStraightSnapAngle( 90 );
	pointpicker.disableStraightSnapAngle( 180 );
	pointpicker.disableStraightSnapAngle( 270 );
	pointpicker.disableStraightSnapAngle( 360 );

	pointpicker.bindResultPt( factory.getInput(2) );
	pointpicker.bindResultOrientation( factory.getInput(1) );
	
	var res = GetPoint( pointpicker );
	ui.clearPickedPoints();
	
	if ( !res )
	{
		factory.cancel();
		return false;
	}
	
	factory.commit();
	
	ui.commandUI.FillFilenameContainer();
		
	return true;
}

function AlignImage()
{
	var ui = moi.ui;

	var image = null;
	var ActiveItem = ui.commandUI.g_ActiveItem;
	if ( ActiveItem != null )
		image = ActiveItem.image;
	
	if ( image == null )
		return;
		
	var imagepoints = new Array();
	if ( !GetLine( imagepoints, 'AlignPrompt1', 'AlignPrompt2' ) )
		return false;
		
	ui.clearPickedPoints();

	ui.beginUIUpdate();
	ui.hideUI( 'AlignPrompt2' );
	ui.showUI( 'AlignPrompt3' );
	ui.endUIUpdate();

	
	var factory = moi.command.createFactory( 'alignbackgroundimage' );
	factory.setImage( image );
	factory.setInput( 0, imagepoints[0] );
	factory.setInput( 1, imagepoints[1] );
	
	var pointpicker = ui.createPointPicker();
	
	pointpicker.bindResultPt( factory.getInput(2) );
	if ( !GetPoint( pointpicker ) )
	{
		factory.cancel();
		return false;
	}
	
	ui.beginUIUpdate();
	ui.hideUI( 'AlignPrompt3' );
	ui.showUI( 'AlignPrompt4' );
	ui.endUIUpdate();

	pointpicker.clearBindings();
	pointpicker.bindResultPt( factory.getInput(3) );
	if ( !GetPoint( pointpicker ) )
	{
		factory.cancel();
		return false;
	}

	factory.commit();
	
	return true;
}

function DoImage()
{
	moi.command.setCommandSpecificUndo( true );

	var editor = moi.ui.createBackgroundImageEditor();
	
	while ( 1 )
	{
		if ( !editor.waitForEvent() )
			return false;
			
		var event = editor.event;
			
		if ( event == 'done' )
			break;
	
		if ( event == 'add' )
		{
			AddImage();
	
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'PromptContainer' );
			moi.ui.hideUI( 'FirstRectPrompt' );
			moi.ui.hideUI( 'LastRectPrompt' );
			moi.ui.showUI( 'ImageOptions' );
			moi.ui.showUI( 'done' );
			moi.ui.endUIUpdate();
		}
		else if ( event == 'align' )
		{
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'ImageOptions' );
			moi.ui.hideUI( 'FirstRectPrompt' );
			moi.ui.hideUI( 'LastRectPrompt' );
			moi.ui.hideUI( 'done' );
			moi.ui.showUI( 'PromptContainer' );
			moi.ui.showUI( 'AlignPrompt1' );
			moi.ui.endUIUpdate();
	
			AlignImage();
			
			moi.ui.beginUIUpdate();
			moi.ui.showUI( 'ImageOptions' );
			moi.ui.showUI( 'done' );
			moi.ui.hideUI( 'PromptContainer' );
			moi.ui.hideUI( 'AlignPrompt1' );
			moi.ui.hideUI( 'AlignPrompt2' );
			moi.ui.hideUI( 'AlignPrompt3' );
			moi.ui.hideUI( 'AlignPrompt4' );
			moi.ui.endUIUpdate();
			
			moi.ui.clearPickedPoints();
		}
		else if ( event == 'undo' )
		{
			editor.undo();
			moi.ui.commandUI.FillFilenameContainer();
		}
		else if ( event == 'redo' )
		{
			editor.redo();
			moi.ui.commandUI.FillFilenameContainer();
		}
	}
}

DoImage();
